
  #include <AT91SAM7X256.H> 
  #include <lib_AT91SAM7X256.H>
  #include <delay.h>

  #define PORTRAIT 

  #define TFTLCD_DATAPORT_B             
  #define TFTLCD_DATAPORT_OFFSET      0
  #define TFTLCD_CONTROLPORT_A          
  #define TFTLCD_RST                  16
  #define TFTLCD_RS                   17
  #define TFTLCD_CS                   18
  #define TFTLCD_WR                   19
  #define TFTLCD_RD                   20                             

  #include "tftlcd_functions.c"
  #include "touch.h"
  #include <stdio.h>

  int x1,y1,color=RED;
  char lcd_buffer[20];

  int main(void) 
  {			 

	tftlcd_init();
	tftlcd_draw_rectangle(0,280,239,319,1,BLACK);
	tftlcd_draw_rectangle(2,282,38,317,1,RED);
	tftlcd_draw_rectangle(42,282,78,317,1,GREEN);
	tftlcd_draw_rectangle(82,282,118,317,1,BLUE);
	tftlcd_draw_rectangle(122,282,158,317,1,WHITE);
	delay_ms(100);

	while(1) {
			
		if (touch(&x1,&y1) == 1) {
			sprintf(lcd_buffer,"X=%u   ",x1);	     
			tftlcd_gotoxy(24,18);
			tftlcd_puts(lcd_buffer,color,BLACK,0);
			sprintf(lcd_buffer,"Y=%u   ",y1);	
			tftlcd_gotoxy(24,19);
			tftlcd_puts(lcd_buffer,color,BLACK,0);

			if (y1 < y_range/10) {	 // 10%
				if (x1<x_range*35/100); //first 35%  for Display X , Y
				else if	(x1<x_range*51/100) color = WHITE; 
				else if (x1<x_range*67/100) color = BLUE; 
				else if (x1<x_range*83/100) color = GREEN;
				else color = RED;

			}else tftlcd_draw_circle(240-(x1*220/x_range),315-(y1*300/y_range),5,1,color);	// draw circle in touch position

		}else tftlcd_draw_rectangle(160,280,239,319,1,BLACK); //clear X , Y
		delay_ms(25);
			
	};
  }
